//Lab. 07: Transform the discrete-time state model into canonical forms.

//              scilab - 5.5.1
//              Operating System : Windows 7, 32-bit
//*****************************************************************************
//Clean the environment
close;
clear;
clc;

// State space model
A=[0 -0.4; 1 -1.3];
B=[0;1];
C=[0 1];
D=0;

sys=syslin('d',A,B,C,D)
mprintf('State space representation of the given discrete system is')
disp(sys)

// Transfer function model
systf=ss2tf(sys)
mprintf('Transfer function of the given discrete system is')
disp(systf)


// Eigen values of system matrix
eig_val=spec(A)
mprintf('Eigen values of the system matrix are')
disp(eig_val)

// Controllable canonical form
[Phi,Gamma,T]=canon(A,B)
T=flipdim(T,2);
Phi=T\A*T;
Gamma=T\B;
C=C*T;
D=D;
sysd=syslin('d',Phi,Gamma,C,D)
mprintf('State space representation of the given discrete system')
disp('in controllable canonical form is')
disp(sysd)

// Diagonal form
[Phid M]=bdiag(A);
Gammad=M\B;
Cd=C*M;
Dd=D;
sysd=syslin('d',Phid,Gammad,Cd,Dd)
mprintf('State space representation of the given')
disp('discrete system in diagonal form is')
disp(sysd)
